program MyCompiler;
uses Windows, Messages, SysUtils, Classes, Dialogs, shellapi, Math
, RegExpr in 'C:\Users\Michael\AppData\Roaming\AtoCC\RegExpr.pas';
///////////////////////////////////////////////////////////
/// Global settings: 
///////////////////////////////////////////////////////////
var i : Integer;

///////////////////////////////////////////////////////////


(* global definitions: *)

type TOutput = class
     public
      Text : String;
      procedure WriteLine(s : String);
      constructor Create();
     end;

constructor TOutput.Create;
begin Text := ''; end;

procedure TOutput.WriteLine(S : String);
begin Text := Text + s; end;

var Output : TOutput;

const t_WH = 257;
const t_Zahl = 258;
const t_KlammerAuf = 259;
const t_KlammerZu = 260;
const t_Farbe = 261;
const t_Farbwert = 262;
const t_RE = 263;
const t_STIFT = 264;
const t_VW = 265;
const t_ignore = 256;
////////////////////////////////////////////////////////////////
/// Scanner
////////////////////////////////////////////////////////////////

type  AToken = record
	token : Integer;
	val   : String;
      end;

var TokenList : Array of AToken;

function FindToken (Rest : String) : AToken;
var r : TRegExpr; Results : Array of Integer; ResultsV : Array of String;
var maxlength,besttoken,i : Integer;
begin
   SetLength(Results,0);
   SetLength(ResultsV,0);
   r := TRegExpr.Create;
   r.Expression := '^(WH)';
   try
	if r.Exec (Rest) then begin
       SetLength(Results,high(Results)+2);
       SetLength(ResultsV,high(ResultsV)+2);
       Results[high(ResultsV)]  := t_WH;
	    ResultsV[high(ResultsV)] := r.Match [0];
	end;
   except writeln('Error in RegExp: ^(WH)'); end;
             
   r.Expression := '^([1-9][0-9]*)';
   try
	if r.Exec (Rest) then begin
       SetLength(Results,high(Results)+2);
       SetLength(ResultsV,high(ResultsV)+2);
       Results[high(ResultsV)]  := t_Zahl;
	    ResultsV[high(ResultsV)] := r.Match [0];
	end;
   except writeln('Error in RegExp: ^([1-9][0-9]*)'); end;
             
   r.Expression := '^(\[)';
   try
	if r.Exec (Rest) then begin
       SetLength(Results,high(Results)+2);
       SetLength(ResultsV,high(ResultsV)+2);
       Results[high(ResultsV)]  := t_KlammerAuf;
	    ResultsV[high(ResultsV)] := r.Match [0];
	end;
   except writeln('Error in RegExp: ^(\[)'); end;
             
   r.Expression := '^(\])';
   try
	if r.Exec (Rest) then begin
       SetLength(Results,high(Results)+2);
       SetLength(ResultsV,high(ResultsV)+2);
       Results[high(ResultsV)]  := t_KlammerZu;
	    ResultsV[high(ResultsV)] := r.Match [0];
	end;
   except writeln('Error in RegExp: ^(\])'); end;
             
   r.Expression := '^(rot|blau|schwarz|gelb)';
   try
	if r.Exec (Rest) then begin
       SetLength(Results,high(Results)+2);
       SetLength(ResultsV,high(ResultsV)+2);
       Results[high(ResultsV)]  := t_Farbe;
	    ResultsV[high(ResultsV)] := r.Match [0];
	end;
   except writeln('Error in RegExp: ^(rot|blau|schwarz|gelb)'); end;
             
   r.Expression := '^(Farbwert)';
   try
	if r.Exec (Rest) then begin
       SetLength(Results,high(Results)+2);
       SetLength(ResultsV,high(ResultsV)+2);
       Results[high(ResultsV)]  := t_Farbwert;
	    ResultsV[high(ResultsV)] := r.Match [0];
	end;
   except writeln('Error in RegExp: ^(Farbwert)'); end;
             
   r.Expression := '^(RE)';
   try
	if r.Exec (Rest) then begin
       SetLength(Results,high(Results)+2);
       SetLength(ResultsV,high(ResultsV)+2);
       Results[high(ResultsV)]  := t_RE;
	    ResultsV[high(ResultsV)] := r.Match [0];
	end;
   except writeln('Error in RegExp: ^(RE)'); end;
             
   r.Expression := '^(STIFT)';
   try
	if r.Exec (Rest) then begin
       SetLength(Results,high(Results)+2);
       SetLength(ResultsV,high(ResultsV)+2);
       Results[high(ResultsV)]  := t_STIFT;
	    ResultsV[high(ResultsV)] := r.Match [0];
	end;
   except writeln('Error in RegExp: ^(STIFT)'); end;
             
   r.Expression := '^(VW)';
   try
	if r.Exec (Rest) then begin
       SetLength(Results,high(Results)+2);
       SetLength(ResultsV,high(ResultsV)+2);
       Results[high(ResultsV)]  := t_VW;
	    ResultsV[high(ResultsV)] := r.Match [0];
	end;
   except writeln('Error in RegExp: ^(VW)'); end;
             
   r.Expression := '^([\r\n\t\s])';
   try
	if r.Exec (Rest) then begin
       SetLength(Results,high(Results)+2);
       SetLength(ResultsV,high(ResultsV)+2);
       Results[high(ResultsV)]  := t_ignore;
	    ResultsV[high(ResultsV)] := r.Match [0];
	end;
   except writeln('Error in RegExp: ^([\r\n\t\s])'); end;
             
	besttoken := 0;
	maxlength := 0;
	result.token := besttoken;
	for i := 0 to high(Results) do begin
		if (length(ResultsV[i]) > maxlength) then begin
			maxlength := length(ResultsV[i]);
			besttoken := Results[i];
         	        result.token := besttoken;
                  	if (besttoken <> 0) then
	                result.val   := ResultsV[i];
		end;
	end;
   r.free;
end;

function Scanner (Input : String) : boolean;
var lasttoken : AToken;
begin
	result := false;
   if (length(Input) = 0) then begin result := true; exit; end;
	while (1=1) do begin
		lasttoken := FindToken(Input);
		if (lasttoken.token = 0) then break;
		if (lasttoken.token <> t_ignore) then begin
		  SetLength(TokenList,high(TokenList)+2); TokenList[high(TokenList)] := lasttoken; end;
		if (length(Input) > length(lasttoken.val)) then
		 delete(Input,1,length(lasttoken.val)) else begin result := true; exit; end;
	end;
	Writeln(Input);
	Writeln('');
	Writeln('No matching token found!');
end;




var
yylexpos : Integer = -1;
yylval   : string = '';

function yylex () : integer;
begin
  inc(yylexpos);
  result := 0;
  if(yylexpos > high(TokenList)) then begin yylval := ''; exit; end;
  yylval := TokenList[yylexpos].val;
  result := TokenList[yylexpos].token;
end;

const yymaxdepth = 10240;

function yyparse : Integer;


var yystate, yysp, yyn    : Integer;
    yys : array [1..yymaxdepth] of Integer;
    yyv : array [1..yymaxdepth] of String;
    yyval : String;

yychar   : Integer; (* current lookahead character *)

yydebug  : Boolean; (* set to true to enable debugging output of parser *)

yyflag    : ( yyfnone, yyfaccept, yyfabort, yyferror );
yyerrflag : Integer;


procedure yyerror ( msg : String );
  begin
    writeln(msg);
  end(*yyerrmsg*);

procedure yyclearin;
  begin
    yychar := -1;
  end(*yyclearin*);

procedure yyaccept;
  begin
    yyflag := yyfaccept;
  end(*yyaccept*);

procedure yyabort;
  begin
    yyflag := yyfabort;
  end(*yyabort*);

procedure yyerrlab;
  begin
    yyflag := yyferror;
  end(*yyerrlab*);

procedure yyerrok;
  begin
    yyerrflag := 0;
  end(*yyerrork*);


procedure yyaction ( yyruleno : Integer );
  (* local definitions: *)
begin
  (* actions: *)
  case yyruleno of
   1 : begin
         yyval := '';
         yyval := yyval + '%!PS-Adobe-2.0 '#13#10;
         yyval := yyval + '/orient 0 def /xpos 0 def /ypos 0 def '#13#10;
         yyval := yyval + '0 0 0 setrgbcolor'#13#10; // Stiftfarbe
         yyval := yyval + '/goto { /ypos exch def /xpos exch def xpos ypos moveto} def'#13#10;
         yyval := yyval + '/turn { /orient exch orient add def} def '#13#10;
         yyval := yyval + '/draw { /len exch def newpath xpos ypos moveto '#13#10;
         yyval := yyval + '   /xpos xpos orient sin len mul add def '#13#10;
         yyval := yyval + '   /ypos ypos orient cos len mul add def '#13#10;
         yyval := yyval + '   xpos ypos lineto stroke '#13#10;
         yyval := yyval + '} def '#13#10;
         yyval := yyval + '300 400 goto'#13#10; // in Blattmitte beginnen
         
         yyval := yyval + yyv[yysp-0]+''#13#10; // Die synthetisierten Inhalte in yyv[yysp-0] anfgen   
         
         Output.WriteLine(yyval);
         
       end;
   2 : begin
         yyval := yyv[yysp-1] + yyv[yysp-0];
         
       end;
   3 : begin
         yyval := '';
         
       end;
   4 : begin
         yyval := '';
         for i := 1 to StrToInt(yyv[yysp-3]) do yyval := yyval + yyv[yysp-1];
         
       end;
   5 : begin
         if (yyv[yysp-0] = 'blau')   then yyval := '0 0 255 setrgbcolor ';
         if (yyv[yysp-0] = 'rot')    then yyval := '255 0 0 setrgbcolor ';
         if (yyv[yysp-0] = 'gruen')  then yyval := '0 255 0 setrgbcolor ';
         if (yyv[yysp-0] = 'gelb')   then yyval := '255 255 0 setrgbcolor ';
         if (yyv[yysp-0] = 'schwarz')then yyval := '0 0 0 setrgbcolor ';
         
       end;
   6 : begin
         yyval := yyv[yysp-0]+' turn ';
         
       end;
   7 : begin
         yyval := yyv[yysp-0]+' setlinewidth ';
         
       end;
   8 : begin
         yyval := yyv[yysp-0]+' draw ';
         
       end;
  end;
end(*yyaction*);

(* parse table: *)

type YYARec = record
                sym, act : Integer;
              end;
     YYRRec = record
                len, sym : Integer;
              end;

const

yynacts   = 27;
yyngotos  = 7;
yynstates = 18;
yynrules  = 8;

yya : array [1..yynacts] of YYARec = (
{ 0: }
  ( sym: 257; act: 4 ),
  ( sym: 261; act: 5 ),
  ( sym: 263; act: 6 ),
  ( sym: 264; act: 7 ),
  ( sym: 265; act: 8 ),
  ( sym: 0; act: -3 ),
{ 1: }
  ( sym: 257; act: 4 ),
  ( sym: 261; act: 5 ),
  ( sym: 263; act: 6 ),
  ( sym: 264; act: 7 ),
  ( sym: 265; act: 8 ),
  ( sym: 0; act: -3 ),
  ( sym: 260; act: -3 ),
{ 2: }
{ 3: }
  ( sym: 0; act: 0 ),
{ 4: }
  ( sym: 258; act: 10 ),
{ 5: }
  ( sym: 262; act: 11 ),
{ 6: }
  ( sym: 258; act: 12 ),
{ 7: }
  ( sym: 258; act: 13 ),
{ 8: }
  ( sym: 258; act: 14 ),
{ 9: }
{ 10: }
  ( sym: 259; act: 15 ),
{ 11: }
{ 12: }
{ 13: }
{ 14: }
{ 15: }
  ( sym: 257; act: 4 ),
  ( sym: 261; act: 5 ),
  ( sym: 263; act: 6 ),
  ( sym: 264; act: 7 ),
  ( sym: 265; act: 8 ),
  ( sym: 260; act: -3 ),
{ 16: }
  ( sym: 260; act: 17 )
{ 17: }
);

yyg : array [1..yyngotos] of YYARec = (
{ 0: }
  ( sym: -4; act: 1 ),
  ( sym: -3; act: 2 ),
  ( sym: -2; act: 3 ),
{ 1: }
  ( sym: -4; act: 1 ),
  ( sym: -3; act: 9 ),
{ 2: }
{ 3: }
{ 4: }
{ 5: }
{ 6: }
{ 7: }
{ 8: }
{ 9: }
{ 10: }
{ 11: }
{ 12: }
{ 13: }
{ 14: }
{ 15: }
  ( sym: -4; act: 1 ),
  ( sym: -3; act: 16 )
{ 16: }
{ 17: }
);

yyd : array [0..yynstates-1] of Integer = (
{ 0: } 0,
{ 1: } 0,
{ 2: } -1,
{ 3: } 0,
{ 4: } 0,
{ 5: } 0,
{ 6: } 0,
{ 7: } 0,
{ 8: } 0,
{ 9: } -2,
{ 10: } 0,
{ 11: } -5,
{ 12: } -6,
{ 13: } -7,
{ 14: } -8,
{ 15: } 0,
{ 16: } 0,
{ 17: } -4
);

yyal : array [0..yynstates-1] of Integer = (
{ 0: } 1,
{ 1: } 7,
{ 2: } 14,
{ 3: } 14,
{ 4: } 15,
{ 5: } 16,
{ 6: } 17,
{ 7: } 18,
{ 8: } 19,
{ 9: } 20,
{ 10: } 20,
{ 11: } 21,
{ 12: } 21,
{ 13: } 21,
{ 14: } 21,
{ 15: } 21,
{ 16: } 27,
{ 17: } 28
);

yyah : array [0..yynstates-1] of Integer = (
{ 0: } 6,
{ 1: } 13,
{ 2: } 13,
{ 3: } 14,
{ 4: } 15,
{ 5: } 16,
{ 6: } 17,
{ 7: } 18,
{ 8: } 19,
{ 9: } 19,
{ 10: } 20,
{ 11: } 20,
{ 12: } 20,
{ 13: } 20,
{ 14: } 20,
{ 15: } 26,
{ 16: } 27,
{ 17: } 27
);

yygl : array [0..yynstates-1] of Integer = (
{ 0: } 1,
{ 1: } 4,
{ 2: } 6,
{ 3: } 6,
{ 4: } 6,
{ 5: } 6,
{ 6: } 6,
{ 7: } 6,
{ 8: } 6,
{ 9: } 6,
{ 10: } 6,
{ 11: } 6,
{ 12: } 6,
{ 13: } 6,
{ 14: } 6,
{ 15: } 6,
{ 16: } 8,
{ 17: } 8
);

yygh : array [0..yynstates-1] of Integer = (
{ 0: } 3,
{ 1: } 5,
{ 2: } 5,
{ 3: } 5,
{ 4: } 5,
{ 5: } 5,
{ 6: } 5,
{ 7: } 5,
{ 8: } 5,
{ 9: } 5,
{ 10: } 5,
{ 11: } 5,
{ 12: } 5,
{ 13: } 5,
{ 14: } 5,
{ 15: } 7,
{ 16: } 7,
{ 17: } 7
);

yyr : array [1..yynrules] of YYRRec = (
{ 1: } ( len: 1; sym: -2 ),
{ 2: } ( len: 2; sym: -3 ),
{ 3: } ( len: 0; sym: -3 ),
{ 4: } ( len: 5; sym: -4 ),
{ 5: } ( len: 2; sym: -4 ),
{ 6: } ( len: 2; sym: -4 ),
{ 7: } ( len: 2; sym: -4 ),
{ 8: } ( len: 2; sym: -4 )
);


const _error = 256; (* error token *)

function yyact(state, sym : Integer; var act : Integer) : Boolean;
  (* search action table *)
  var k : Integer;
  begin
    k := yyal[state];
    while (k<=yyah[state]) and (yya[k].sym<>sym) do inc(k);
    if k>yyah[state] then
      yyact := false
    else
      begin
        act := yya[k].act;
        yyact := true;
      end;
  end(*yyact*);

function yygoto(state, sym : Integer; var nstate : Integer) : Boolean;
  (* search goto table *)
  var k : Integer;
  begin
    k := yygl[state];
    while (k<=yygh[state]) and (yyg[k].sym<>sym) do inc(k);
    if k>yygh[state] then
      yygoto := false
    else
      begin
        nstate := yyg[k].act;
        yygoto := true;
      end;
  end(*yygoto*);

label parse, next, error, errlab, shift, reduce, accept, abort;

begin(*yyparse*)

  (* initialize: *)

  yystate := 0; yychar := -1; yyerrflag := 0; yysp := 0;

{$ifdef yydebug}
  yydebug := true;
{$else}
  yydebug := false;
{$endif}

parse:

  (* push state and value: *)

  inc(yysp);
  if yysp>yymaxdepth then
    begin
      yyerror('yyparse stack overflow');
      goto abort;
    end;
  yys[yysp] := yystate; yyv[yysp] := yyval;

next:

  if (yyd[yystate]=0) and (yychar=-1) then
    (* get next symbol *)
    begin
      yychar := yylex; if yychar<0 then yychar := 0;
    end;

  if yydebug then writeln('state ', yystate, ', char ', yychar);

  (* determine parse action: *)

  yyn := yyd[yystate];
  if yyn<>0 then goto reduce; (* simple state *)

  (* no default action; search parse table *)

  if not yyact(yystate, yychar, yyn) then goto error
  else if yyn>0 then                      goto shift
  else if yyn<0 then                      goto reduce
  else                                    goto accept;

error:

  (* error; start error recovery: *)

  if yyerrflag=0 then yyerror('syntax error');

errlab:

  if yyerrflag<=2 then                  (* incomplete recovery; try again *)
    begin
      yyerrflag := 3;
      (* uncover a state with shift action on error token *)
      while (yysp>0) and not ( yyact(yys[yysp], _error, yyn) and
                               (yyn>0) ) do
        begin
          if yydebug then
            if yysp>1 then
              writeln('error recovery pops state ', yys[yysp], ', uncovers ',
                      yys[yysp-1])
            else
              writeln('error recovery fails ... abort');
          dec(yysp);
        end;
      if yysp=0 then goto abort; (* parser has fallen from stack; abort *)
      yystate := yyn;            (* simulate shift on error *)
      goto parse;
    end
  else                                  (* no shift yet; discard symbol *)
    begin
      if yydebug then writeln('error recovery discards char ', yychar);
      if yychar=0 then goto abort; (* end of input; abort *)
      yychar := -1; goto next;     (* clear lookahead char and try again *)
    end;

shift:

  (* go to new state, clear lookahead character: *)

  yystate := yyn; yychar := -1; yyval := yylval;
  if yyerrflag>0 then dec(yyerrflag);

  goto parse;

reduce:

  (* execute action, pop rule from stack, and go to next state: *)

  if yydebug then writeln('reduce ', -yyn);

  yyflag := yyfnone; yyaction(-yyn);
  dec(yysp, yyr[-yyn].len);
  if yygoto(yys[yysp], yyr[-yyn].sym, yyn) then yystate := yyn;

  (* handle action calls to yyaccept, yyabort and yyerror: *)

  case yyflag of
    yyfaccept : goto accept;
    yyfabort  : goto abort;
    yyferror  : goto errlab;
  end;

  goto parse;

accept:

  yyparse := 0; exit;

abort:

  yyparse := 1; exit;

end(*yyparse*);


var ShowTokens : boolean = false;
    InputFilename : String = '';
    OutputFilename : String = ''; 
    iterationVar : Integer; SL : TStringList; inputstream,outputstream  : string ;
begin
try 
 for iterationVar := 1 to ParamCount do begin
  if lowercase(ParamStr(iterationVar)) =  '-t' then ShowTokens := true else
  if (InputFilename = '') then InputFilename := ParamStr(iterationVar) else
  if (OutputFilename = '') then OutputFilename := ParamStr(iterationVar) else begin
   Writeln('Too many argument!');
   ExitCode := 1;
   exit;
  end;
 end;
 if (InputFilename = '') then begin
   Writeln('You need to specify input and outputfile: compiler.exe input.txt output.txt');
   ExitCode := 1;
   exit;
 end;
 SL := TStringList.Create();
 SL.LoadFromFile(InputFilename);
 inputstream := SL.Text;
 while(inputstream[length(inputstream)] = #10)or(inputstream[length(inputstream)] = #13) do
  Delete(inputstream,length(inputstream),1);
 SL.Free;
 outputstream := '';


 if not Scanner(inputstream) then begin
  ExitCode := 1;
  exit;
 end;

 if (ShowTokens) then begin
  for iterationVar := 0 to high(TokenList) do 
   WriteLn('TokenID: ',TokenList[iterationVar].token,'  =  '+TokenList[iterationVar].val);
 end;

 Output := TOutput.Create();

 if yyparse() <> 0 then begin
  ExitCode := 1;
  exit;
 end;

 outputstream := Output.Text;

 if (OutputFilename <> '') then begin
  SL := TStringList.Create();
  SL.SetText(pchar(outputstream));
  SL.SaveToFile(OutputFilename);
  SL.Free;
 end else 
  Writeln(outputstream);
Except
end;
 ExitCode := 0;
end.

